package gov.va.med.mhv.liferay.saml.binding.impl;

import org.opensaml.common.binding.decoding.URIComparator;
import org.opensaml.saml2.binding.decoding.HTTPRedirectDeflateDecoder;
import org.opensaml.xml.parse.ParserPool;

import com.liferay.saml.binding.impl.HttpRedirectBinding;

import gov.va.med.mhv.liferay.saml.binding.decoding.MhvCustomURIComparator;

public class MhvHttpRedirectBinding extends HttpRedirectBinding {

	public MhvHttpRedirectBinding(ParserPool parserPool) {
		super(parserPool);
		
		// override URI comparator 
		HTTPRedirectDeflateDecoder messageDecoder = (HTTPRedirectDeflateDecoder)this.getMessageDecoder();
		messageDecoder.setURIComparator(new MhvCustomURIComparator());
	}
	
	public MhvHttpRedirectBinding(ParserPool parserPool, URIComparator uriComparator) {
		super(parserPool);
		
		// override URI comparator 
		HTTPRedirectDeflateDecoder messageDecoder = (HTTPRedirectDeflateDecoder)this.getMessageDecoder();
		messageDecoder.setURIComparator(uriComparator);
	}
	
	

}
